//+------------------------------------------------------------------+
//|                                               Awesome_MTF_NL.mq4 |
//| -Multitimeframe    Normalized / Line                             |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                 http://www.mql5.com/ru/code/7813 |
//|                                   Some features add by AST, 2014 |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2005, MetaQuotes Software Corp."
#property  link      "http://www.metaquotes.net/"
//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 6
#property  indicator_level1 0.0
#property  indicator_levelwidth 0
#property  indicator_levelstyle STYLE_SOLID
#property  indicator_levelcolor SlateGray

#property  indicator_color1  Black
#property  indicator_color2  Green //colors for 1'st AO
#property  indicator_color3  Green

#property  indicator_color4  Black
#property  indicator_color5  Red //colors for 2'st AO
#property  indicator_color6  Red

#property  indicator_width1 0
#property  indicator_width2 2
#property  indicator_width3 2

#property  indicator_width4 0
#property  indicator_width5 2
#property  indicator_width6 2


extern int  AO_TF1=0; // Timeframe
extern int  MA_Fast1=5; //standart AO SMA fast Period=5
extern int  MA_Slow1=34; //standart AO SMA slow Period=34
extern bool AO_Show_Line1=true;

extern int  AO_TF2=0; // Timeframe
extern int  MA_Fast2=21; //custom AO SMA fast Period
extern int  MA_Slow2=55; //custom AO SMA slow Period
extern bool AO_Show_Line2=true;

//---- indicator buffers
double     ExtBuffer0[];
double     ExtBuffer1[];
double     ExtBuffer2[];

double     ExtBuffer3[];
double     ExtBuffer4[];
double     ExtBuffer5[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(6);
   IndicatorDigits(2);
   //---- drawing settings
   if (AO_Show_Line1)
   {
     SetIndexStyle(0,DRAW_NONE);
     SetIndexStyle(1,DRAW_LINE);
     SetIndexStyle(2,DRAW_LINE);
   } else
   {
     SetIndexStyle(0,DRAW_NONE);
     SetIndexStyle(1,DRAW_HISTOGRAM);
     SetIndexStyle(2,DRAW_HISTOGRAM);
   }

   if (AO_Show_Line2)
   {
     SetIndexStyle(3,DRAW_NONE);
     SetIndexStyle(4,DRAW_LINE);
     SetIndexStyle(5,DRAW_LINE);
   } else
   {
     SetIndexStyle(3,DRAW_NONE);
     SetIndexStyle(4,DRAW_HISTOGRAM);
     SetIndexStyle(5,DRAW_HISTOGRAM);
   }

   SetIndexDrawBegin(0,MA_Slow1);
   SetIndexDrawBegin(1,MA_Slow1);
   SetIndexDrawBegin(2,MA_Slow1);

   SetIndexDrawBegin(3,MA_Slow2);
   SetIndexDrawBegin(4,MA_Slow2);
   SetIndexDrawBegin(5,MA_Slow2);

//---- 6 indicator buffers mapping
   SetIndexBuffer(0,ExtBuffer0);
   SetIndexBuffer(1,ExtBuffer1);
   SetIndexBuffer(2,ExtBuffer2);
   SetIndexBuffer(3,ExtBuffer3);
   SetIndexBuffer(4,ExtBuffer4);
   SetIndexBuffer(5,ExtBuffer5);
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("AO ("+MA_Fast1+","+MA_Slow1+") TF_"+StrPer(AO_TF1)+"+ AO ("+MA_Fast2+","+MA_Fast2+") TF_"+StrPer(AO_TF2));
   SetIndexLabel(1,NULL);
   SetIndexLabel(2,NULL);
   SetIndexLabel(4,NULL);
   SetIndexLabel(5,NULL);
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Awesome Oscillator                                               |
//+------------------------------------------------------------------+
int start()
{
   int    limit;
   int    counted_bars=IndicatorCounted();
   double AO1_prev,AO1_current,AO2_prev,AO2_current;
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   if(counted_bars==0) limit-=1+1;
//---- macd

   for(int i=0; i<limit; i++)
   {
     ExtBuffer0[i]=(iMA(NULL,AO_TF1,MA_Fast1,0,MODE_SMA,PRICE_MEDIAN,i)-iMA(NULL,AO_TF1,MA_Slow1,0,MODE_SMA,PRICE_MEDIAN,i))/Point;
     ExtBuffer3[i]=(iMA(NULL,AO_TF2,MA_Fast2,0,MODE_SMA,PRICE_MEDIAN,i)-iMA(NULL,AO_TF2,MA_Slow2,0,MODE_SMA,PRICE_MEDIAN,i))/Point;
   }
//---- dispatch values between 2 buffers

   bool AO1_up=true, AO2_up=true;
   for(i=limit-1; i>=0; i--)
   {
      AO1_current=ExtBuffer0[i];
      AO1_prev=ExtBuffer0[i+1];

      AO2_current=ExtBuffer3[i];
      AO2_prev=ExtBuffer3[i+1];

      if(AO1_current>AO1_prev) AO1_up=true;
      if(AO1_current<AO1_prev) AO1_up=false;

      if(AO2_current>AO2_prev) AO2_up=true;
      if(AO2_current<AO2_prev) AO2_up=false;

      if(!AO1_up)
      {
         ExtBuffer2[i]=AO1_current;
         ExtBuffer1[i]=EMPTY_VALUE;
         ExtBuffer1[i+1]=AO1_prev;

      }
      else
      {
         ExtBuffer1[i]=AO1_current;
         ExtBuffer2[i]=EMPTY_VALUE;
         ExtBuffer1[i+1]=AO1_prev;
      }

      if(!AO2_up)
      {
         ExtBuffer5[i]=AO2_current;
         ExtBuffer4[i]=EMPTY_VALUE;
         ExtBuffer4[i+1]=AO2_prev;

      }
      else
      {
         ExtBuffer4[i]=AO2_current;
         ExtBuffer5[i]=EMPTY_VALUE;
         ExtBuffer4[i+1]=AO2_prev;
      }
   }
//---- done
   return(0);
}

//------------------------------------Period return----------------------------------------
string StrPer(int per)
{
   if (per==0) per=Period();
   if (per == 1)     return("M1 ");
   if (per == 5)     return("M5 ");
   if (per == 15)    return("M15 ");
   if (per == 30)    return("M30 ");
   if (per == 60)    return("H1 ");
   if (per == 240)   return("H4 ");
   if (per == 1440)  return("D1 ");
   if (per == 10080) return("W1 ");
   if (per == 43200) return("MN ");
return(" ");
}