#property copyright "InstaForex"
#property link      "http://www.instaforex.com/"

#property indicator_buffers 3
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_color3 Green

input int KPeriod = 30;
input int CalcBars = 1000;
double RWHL[];

double Pk[];
double PkGreen[];
double PkRed[];

double MN[];
double SD[];
double v1, v2;
double Line[];

#property indicator_separate_window

// +------------------------------------------------------------------+
// | Custom indicator initialization function                         |
// +------------------------------------------------------------------+
int OnInit()
{
	// ---- indicators
	IndicatorBuffers(7);

	SetIndexStyle(0, DRAW_HISTOGRAM, EMPTY, 1);
	SetIndexBuffer(0, PkGreen);

	SetIndexStyle(1, DRAW_HISTOGRAM, EMPTY, 1);
	SetIndexBuffer(1, PkRed);

	SetIndexStyle(2, DRAW_LINE, EMPTY, 1);
	SetIndexBuffer(2, Line);

	SetIndexBuffer(3, RWHL);
	SetIndexBuffer(4, MN);
	SetIndexBuffer(5, SD);
	SetIndexBuffer(6, Pk);
	// ---
	return (INIT_SUCCEEDED);
}

// +------------------------------------------------------------------+
// | Custom indicator iteration function                              |
// +------------------------------------------------------------------+
int OnCalculate(const int rates_total,
	const int prev_calculated,
	const datetime &time[],
	const double &open[],
	const double &high[],
	const double &low[],
	const double &close[],
	const long &tick_volume[],
	const long &volume[],
	const int &spread[])
{
	int limit = CalcBars;
	// ----
	for (int i = 0; i <= limit; i++)
	{
		double H = (High[i] - Low[i + KPeriod]) / (iATR(Symbol(), 0, KPeriod, i) * MathSqrt(KPeriod));
		double L = (High[i + KPeriod] - Low[i]) / (iATR(Symbol(), 0, KPeriod, i) * MathSqrt(KPeriod));

		RWHL[i] = H - L;
	}

	for (int p = 0; p <= limit; p++)
		Pk[p] = iMAOnArray(RWHL, 0, 3, 0, MODE_LWMA, p);
	for (int m = 0; m <= limit; m++)
		MN[m] = iMAOnArray(Pk, 0, KPeriod, 0, MODE_SMA, m);
	for (int s = 0; s <= limit; s++)
		SD[s] = iStdDevOnArray(Pk, 0, KPeriod, MODE_SMA, 0, s);

	for (int v = 0; v <= limit; v++)
	{
		if (MN[v] + (1.33 * SD[v]) > 2.08)
			v1 = MN[v] + (1.33 * SD[v]);
		else
			v1 = 2.08;

		if (MN[v] - (1.33 * SD[v]) < -1.92)
			v2 = MN[v] - (1.33 * SD[v]);
		else
			v2 = -1.92;

		if (Pk[v + 1] > Pk[v])
		{
			PkRed[v] = Pk[v];
			PkGreen[v] = 0;
		}
		else
		{
			PkRed[v] = 0;
			PkGreen[v] = Pk[v];
		}

		if (Pk[v + 1] >= 0 && Pk[v] > 0)
		{
			Line[v] = v1;
		}
		else
		{
			if (Pk[v + 1] <= 0 && Pk[v] < 0)
			{
				Line[v] = v2;
			}
			else
			{
				Line[v] = 0;
			}
		}
	}

	// ----
	return (0);
}
// +------------------------------------------------------------------+